<div class="alert alert-info">
    <i class="fa fa-info"></i>

	<?php
    // The base url is the url where we'll pass the filter parameters
    $base_url = array('controller' => 'stats', 'action' => 'mobile');
    echo $this->Form->create('Filter', array(
        'url' => $base_url,
        'class' => 'form-inline',
        'inputDefaults' => array(
            //'label' => false,
            'div' => 'form-group',
            'class' => 'form-control input-sm',
            'error' => array(
                'attributes' => array('wrap' => 'span', 'class' => 'help-block')
            ),
        ),
    ));
    ?>

    <?php echo $this->Form->input('date_from', array('type' => 'date', 'placeholder' => __('From'), 'minYear' => date('Y') - 3, 'maxYear' => date('Y'))); ?>

    <?php echo $this->Form->input('date_to', array('type' => 'date', 'placeholder' => __('To'), 'minYear' => date('Y') - 3, 'maxYear' => date('Y'))); ?>

    <?php echo $this->Form->submit('Filter', array('div' => false, 'class' => 'btn btn-default btn-sm')); ?>
    <?php echo $this->Html->link('Reset', $base_url); ?>
    <?php echo $this->Form->end(); ?>

</div>


<div class="row">
    <div class="col-sm-6">
        <div class="box box-success">
            <div class="box-header">
                <h3 class="box-title">Mobile Device Brands</h3>
            </div>
            <div class="box-body" style="height: 300px;overflow: auto;">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Clicks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($link_brands as $link_brand) {
                            echo '<tr>';
                            echo '<td>';
                            echo $link_brand['Stat']['device_brand'];
                            echo '</td>';
                            echo '<td>';
                            echo $link_brand[0]['num'];
                            echo '</td>';
                            echo '</tr>';
                        }
                        unset($link_brand);
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-6">
        <div class="box box-success">
            <div class="box-header">
                <h3 class="box-title">Mobile Device Names</h3>
            </div>
            <div class="box-body" style="height: 300px;overflow: auto;">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Clicks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($link_device_names as $link_device_name) {
                            echo '<tr>';
                            echo '<td>';
                            echo $link_device_name['Stat']['device_name'];
                            echo '</td>';
                            echo '<td>';
                            echo $link_device_name[0]['num'];
                            echo '</td>';
                            echo '</tr>';
                        }
                        unset($link_device_name);
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
